/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.tomcat;

import com.ibm.hwmca.fw.connmgr.ConnectionConstants;
import com.ibm.hwmca.fw.managed.User;
import com.ibm.hwmca.fw.servlet.util.HMCSession;
import com.ibm.hwmca.fw.servlet.util.ServletRuntime;
import com.ibm.hwmca.fw.system.ClientUserContext;
import com.ibm.hwmca.fw.tomcat.HmcPrincipal;
import com.ibm.hwmca.fw.tomcat.RegisterRemoteUser;
import com.ibm.hwmca.fw.util.Trace;
import java.io.IOException;
import java.security.Principal;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.catalina.HttpRequest;
import org.apache.catalina.HttpResponse;
import org.apache.catalina.Manager;
import org.apache.catalina.Session;
import org.apache.catalina.authenticator.FormAuthenticator;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.catalina.deploy.SecurityConstraint;

public class HmcFormAuthenticator
extends FormAuthenticator {
    private static final String TRACE_MASKT = "XTOMFAUT";
    private static final String TRACE_MASKF = "XTOMFAUF";
    private static final String TRACE_MASKD = "XTOMFAUD";
    private static HmcFormAuthenticator instance;
    public static final String PRELOGON_SERVLET_URI = "/hmc/preLogon";
    private Object propertyChangeMonitor = new Object();
    private static TreeMap uriMap;

    public HmcFormAuthenticator() {
        Trace.trace(TRACE_MASKF, "<> HmcFormAuthenticator.ctor()");
        instance = this;
    }

    public static HmcFormAuthenticator getHmcFormAuthenticator() {
        return instance;
    }

    public boolean authenticate(HttpRequest request, HttpResponse response, LoginConfig config) throws IOException {
        Trace.trace(TRACE_MASKF, "-> HmcFormAuthenticator.authenticate()");
        Trace.trace(TRACE_MASKF, "request=[" + request.getDecodedRequestURI() + "]");
        boolean bAuth = false;
        String uri = ((HttpServletRequest)request.getRequest()).getRequestURI();
        Trace.trace(TRACE_MASKF, "Trying to access URI: " + uri);
        String remoteAddr = request.getRequest().getRemoteAddr();
        if (PRELOGON_SERVLET_URI.equals(uri)) {
            if ("127.0.0.1".equals(remoteAddr)) {
                Trace.trace(TRACE_MASKF, "Accessing Startup Servlet from localhost.. allowing");
                Principal principal = this.context.getRealm().authenticate("logonuser", ConnectionConstants.LOGON_PASSWORD);
                if (principal != null) {
                    Trace.trace(TRACE_MASKF, "Authenticated PreLogon guy");
                    Session session = this.getSession(request, true);
                    session.setNote("org.apache.catalina.authenticator.PRINCIPAL", (Object)principal);
                    this.register(request, response, principal, "FORM", "logonuser", null);
                } else {
                    Trace.trace(TRACE_MASKF, "Failed to authenticate PreLogon guy");
                }
                bAuth = true;
            } else {
                Trace.trace(TRACE_MASKF, "Accessing Startup Servlet from " + request.getRequest().getRemoteAddr() + ".. Rejecting");
                bAuth = false;
            }
        } else if (uriMap.size() > 0) {
            Set uriSet = uriMap.keySet();
            boolean uriFound = false;
            Iterator it = uriSet.iterator();
            while (it.hasNext()) {
                String uriKey = (String)it.next();
                if (!uriKey.equals(uri)) continue;
                RegisterRemoteUser rru = (RegisterRemoteUser)uriMap.get(uriKey);
                String[] logonInfo = rru.getLogonInfo();
                if (logonInfo[0].equals(remoteAddr)) {
                    User user = User.getUser(logonInfo[1]);
                    Principal principal = this.context.getRealm().authenticate(logonInfo[1], user.getPassword());
                    if (principal != null) {
                        Trace.trace(TRACE_MASKF, "Authenticated Registered Remote User");
                        Session session = this.getSession(request, true);
                        session.setNote("org.apache.catalina.authenticator.PRINCIPAL", (Object)principal);
                        this.register(request, response, principal, "FORM", logonInfo[1], null);
                        bAuth = true;
                        HttpSession httpSession = ((HttpServletRequest)request).getSession();
                        session.setAuthType("FORM");
                        session.setPrincipal(principal);
                        session.setNote("org.apache.catalina.session.USERNAME", (Object)logonInfo[1]);
                        session.setNote("org.apache.catalina.session.PASSWORD", (Object)user.getPassword());
                        HMCSession hmcSession = HMCSession.getHMCSession(httpSession);
                        rru.sessionAuthenticated(hmcSession);
                        ClientUserContext userContext = new ClientUserContext(((HmcPrincipal)((Object)principal)).getConnectionFactory());
                        try {
                            ServletRuntime.getRuntime().updateUserContext(userContext, (HttpServletRequest)request);
                            hmcSession.setUserContext(userContext);
                            userContext.attachToThread(true);
                        }
                        catch (Exception e) {
                            Trace.trace(TRACE_MASKF, e);
                        }
                    }
                } else {
                    Trace.trace(TRACE_MASKF, "Accessing Startup Servlet from " + request.getRequest().getRemoteAddr() + ".. Rejecting");
                    bAuth = false;
                }
                uriFound = true;
                break;
            }
            if (!uriFound) {
                Trace.trace(TRACE_MASKF, "Using superclass to authenticate access to " + uri);
                bAuth = super.authenticate(request, response, config);
            }
        } else {
            Trace.trace(TRACE_MASKF, "Using superclass to authenticate access to " + uri);
            bAuth = super.authenticate(request, response, config);
        }
        Trace.trace(TRACE_MASKF, "<- HmcFormAuthenticator.authenticate(" + bAuth + ")");
        return bAuth;
    }

    public boolean accessControl(HttpRequest request, HttpResponse response, SecurityConstraint constraint) throws IOException {
        boolean bAuth;
        Trace.trace(TRACE_MASKF, "-> HmcFormAuthenticator.accessControl()");
        Trace.trace(TRACE_MASKF, "request=[" + request.getDecodedRequestURI() + "]");
        String uri = ((HttpServletRequest)request.getRequest()).getRequestURI();
        Trace.trace(TRACE_MASKF, "Trying to access URI: " + uri);
        String remoteAddr = request.getRequest().getRemoteAddr();
        if (uri.equals(PRELOGON_SERVLET_URI)) {
            if ("127.0.0.1".equals(remoteAddr)) {
                Trace.trace(TRACE_MASKF, "Accessing PreLogon Servlet from localhost.. allowing");
                bAuth = true;
            } else {
                Trace.trace(TRACE_MASKF, "Accessing PreLogon Servlet from " + request.getRequest().getRemoteAddr() + ".. Rejecting");
                bAuth = false;
            }
        } else {
            bAuth = super.accessControl(request, response, constraint);
        }
        Trace.trace(TRACE_MASKF, "<- HmcFormAuthenticator.accessControl(" + bAuth + ")");
        return bAuth;
    }

    protected Object getPropertyChangeMonitor() {
        return this.propertyChangeMonitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerRemoteUser(String uri, RegisterRemoteUser rru) {
        Trace.trace(TRACE_MASKF, "HmcFormAuthenticator.registerRemoteUser( " + uri + " , " + rru + " )");
        Object object = this.getPropertyChangeMonitor();
        synchronized (object) {
            uriMap.put(uri, rru);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unRegisterRemoteUser(String uri) {
        Trace.trace(TRACE_MASKF, "HmcFormAuthenticator.unRegisterRemoteUser( " + uri + " )");
        Object object = this.getPropertyChangeMonitor();
        synchronized (object) {
            uriMap.remove(uri);
        }
    }

    public void log(String msg) {
        Trace.trace(TRACE_MASKF, msg);
    }

    public void log(String msg, Throwable t) {
        Trace.trace(TRACE_MASKF, msg);
        Trace.trace(TRACE_MASKF, t);
    }

    public Principal authenticate(String username, byte[] password, HttpSession hses) throws IOException {
        Trace.trace(TRACE_MASKT, "-> HmcFormAuthenticator.authenticate(username, password, hses)");
        Trace.trace(TRACE_MASKF, "HmcFormAuthenticator: authenticating '" + username + "'");
        Principal principal = this.context.getRealm().authenticate(username, password);
        if (principal == null) {
            throw new IOException("Failed authentication");
        }
        Trace.trace(TRACE_MASKF, "HmcFormAuthenticator: Authenticated '" + username + "'");
        Manager manager = this.context.getManager();
        if (manager == null) {
            throw new IOException("No Manager found");
        }
        Session session = manager.findSession(hses.getId());
        if (session == null) {
            throw new IOException("Could not find session");
        }
        session.setAuthType("FORM");
        session.setPrincipal(principal);
        session.setNote("org.apache.catalina.authenticator.PRINCIPAL", (Object)principal);
        session.setNote("org.apache.catalina.session.USERNAME", (Object)username);
        session.setNote("org.apache.catalina.session.PASSWORD", (Object)password);
        return principal;
    }

    static {
        uriMap = new TreeMap();
    }
}

